// Step Modes
const unsigned short FULL_STEP_MODE=0;
const unsigned short HALF_STEP_MODE=1;

// Step Values
unsigned short stepFull[]={0b00001000,0b00000100,0b00000010,0b00000001};
unsigned short stepHalf[]={0b00001100,0b00000110,0b00000011,0b00001001};

unsigned short stepTimer=0;
unsigned short Step_Controls=0;

signed short stepIndex=0;          // Step motor adim index degeri
unsigned int speed;                // Step motor hiz degiskeni
unsigned int location=0;           // Step motor konum degiskeni
unsigned int currentLocation=0;    // Step motor anlik konum degeri

void InitStep(){
  Step_Controls=1;
}

void step_delay_10us(unsigned int time){
  while(time--)
    Delay_10us();
}


void StepMotorListener(unsigned int location, unsigned int time){
  if(Step_Controls){
    if(currentLocation!=location){
      time/=50;
      stepTimer++;
      if(stepTimer>time){
        stepTimer=0;
        if(currentLocation<location){
          currentLocation++;
          STEP_IN1=stepFull[currentLocation%4].B0;
          STEP_IN2=stepFull[currentLocation%4].B1;
          STEP_IN3=stepFull[currentLocation%4].B2;
          STEP_IN4=stepFull[currentLocation%4].B3;
        }
        else if(currentLocation>location){
          currentLocation--;
          STEP_IN1=stepFull[currentLocation%4].B0;
          STEP_IN2=stepFull[currentLocation%4].B1;
          STEP_IN3=stepFull[currentLocation%4].B2;
          STEP_IN4=stepFull[currentLocation%4].B3;
        }
      }
    }
    else{  // currentLocation==location
      STEP_IN1=0;
      STEP_IN2=0;
      STEP_IN3=0;
      STEP_IN4=0;
    }
  }
}

void SetStepMotor(signed int step, unsigned short mode, unsigned int time){
  time/=20;
  while(step<0 || step>0){
    STEP_IN1=stepFull[stepIndex].B0;
    STEP_IN2=stepFull[stepIndex].B1;
    STEP_IN3=stepFull[stepIndex].B2;
    STEP_IN4=stepFull[stepIndex].B3;

    step_delay_10us(time);

    if(mode==HALF_STEP_MODE){
      STEP_IN1=stepHalf[stepIndex].B0;
      STEP_IN2=stepHalf[stepIndex].B1;
      STEP_IN3=stepHalf[stepIndex].B2;
      STEP_IN4=stepHalf[stepIndex].B3;
    }
    else{
      STEP_IN1=stepFull[stepIndex].B0;
      STEP_IN2=stepFull[stepIndex].B1;
      STEP_IN3=stepFull[stepIndex].B2;
      STEP_IN4=stepFull[stepIndex].B3;
    }

    step_delay_10us(time);


    if(step>0){
      stepIndex++;
      step--;
      if(stepIndex>3)
        stepIndex=0;
    }
    else if(step<0){
      stepIndex--;
      step++;
      if(stepIndex<0)
        stepIndex=3;
    }
  }

  STEP_IN1=0;
  STEP_IN2=0;
  STEP_IN3=0;
  STEP_IN4=0;
}